/*****************************************************************************
*  LPC8xx SCT demo program
*
*  Use SCT timer to generate 2 PWM signals with different
*  dutycycles @ SCT_OUT0 and SCT_OUT1
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7);             // enable clock to SWM

    LPC_SWM->PINASSIGN5 = 0x06FFFFFF;                  // SCT_IN0  at P0_6
    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                  // SCT_OUT0 at P0_7
    LPC_SWM->PINASSIGN7 = 0xFFFFFF08;                  // SCT_OUT1 at P0_8

    SCT_Init();                                        // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
